ORCA/M Asm65816 2.1.0

0001 178A                       title 'Memory Peeker Desk Accessory'
0002 178A              ********************************************************************************
0003 178A              *
0004 178A              * Memory Peeker
0005 178A              *
0006 178A              * by Rich Williams May 1986
0007 178A              *
0008 178A              * This is a classic DA that displays the memory lists
0009 178A              * This is not part of the memory manager at all and is included because
0010 178A              * there is extra room
0011 178A              *
0012 178A              * Rev 2 changes
0013 178A              * 1) Shutdown call added (just an RTL)
0014 178A              *
0015 178A              *
0016 178A              * Change History
0017 178A              *
0018 178A              * ?? ??? ??	Rich Williams
0019 178A              *
0020 178A              * Added shutdown call for version 2.0 of rom.
0021 178A              *
0022 178A              *
0023 178A              * 23 Aug 88	Steven Glass
0024 178A              *
0025 178A              * Separated this code from memory manager.
0026 178A              * Changed way lists are paused and interrupted.
0027 178A              *
0028 178A              *
0029 178A              ********************************************************************************
0030 178A                       include 'all.macros' 
0031 178A
0032 178A                       include 'mm.equates.asm' 
0033 178A
0034 178A              ;-----------------------------------------------------------
0035 178A              ;
0036 178A              ; These are variables used in zero page
0037 178A              ; the DA manager saves and restores zero page for us
0038 178A              ;
0039 178A              ;
0040 178A              ; Note that the order of the variables after the event record
0041 178A              ; is very important.  The code that draws the handle relys on the
0042 178A              ; buffer being 5 bytes past MyCount.  It also relys on Ptr being
0043 178A              ; only 3 bytes long.
0044 178A              ;
0045 178A                       DSect $80
0046 178A              EventRecord word  
0047 178A              EventMessage long 
0048 178A              EventWhen long 
0049 178A              EventWhere long 
0050 178A              EventMods word 
0051 178A              EventType equ   EventRecord
0052 178A              EventKey equ   EventMessage
0053 178A
0054 178A
0055 178A              Mycount  word 
0056 178A              Ptr      block 3
0057 178A              buffer   block HSize
0058 178A              MyDelta  long 
0059 178A              MyTotal  long 
0060 178A              line     long 
0061 178A
0062 178A
0063 178A              ptr2     equ Buffer+hndl_next 
0064 178A
0065 178A
0066 178A
0067 178A
0068 178A              ****************************************************************
0069 178A              *
0070 178A              InstallPeekerDA PROC EXPORT 
0071 178A              *
0072 178A              * This is the code that installs the peeker desk accessory.
0073 178A              *
0074 178A              *
0075 178A              *
0076 178A              * Inputs:
0077 178A              *	none
0078 178A              *
0079 178A              * Outputs:
0080 178A              *	none
0081 178A              *
0082 178A              * External Refs:
0083 178A                       import Peeker 
0084 178A                       import PeekerID 
0085 178A              *
0086 178A              * Entry Points:
0087 178A              *	none
0088 178A              *
0089 178A                       longa on                       ; mode
0090 178A                       longi on
0091 178A              *
0092 178A              ****************************************************************
0093 178A
0094 178A                       longa on
0095 178A                       longi on
0096 178A
0097 178A C2 30                 rep   #$30                     ;Make sure 16 bits
0098 178C
0099 178C F4 FC 00 F4           PushLong #PeekerID 
0100 1792 A2 05 0F 22           _InstallCDA 
0101 1799
0102 1799 6B                    rtl   
0103 179A
0104 179A
0105 179A                       ENDP 
0106 179A
0107 179A
0108 179A              ****************************************************************
0109 179A              *
0110 179A              Peeker   PROC 
0111 179A              *
0112 179A              * This is the code that runs the DA.
0113 179A              *
0114 179A              *
0115 179A              * Inputs:
0116 179A              *	none
0117 179A              *
0118 179A              * Outputs:
0119 179A              *	none
0120 179A              *
0121 179A              * External Refs:
0122 179A                       import Freeze 
0123 179A                       import ReadKey 
0124 179A                       import B3 
0125 179A                       import PrintThisLine 
0126 179A                       import DoLine 
0127 179A              *
0128 179A              * Entry Points:
0129 179A              *	none
0130 179A              *
0131 179A                       longa on                       ; mode
0132 179A                       longi on
0133 179A              *
0134 179A              ****************************************************************
0135 179A
0136 179A              *
0137 179A              * First initialize the output to the screen
0138 179A              *
0139 179A
0140 179A F4 00 00              pea   0                        ;Get Output device
0141 179D F4 00 00              pea   0
0142 17A0 F4 00 00              pea   0
0143 17A3 A2 0C 13 22           _GetOutputDevice 
0144 17AA
0145 17AA F4 00 00              pea   0
0146 17AD F4 00 00              pea   0
0147 17B0 A2 0C 0D 22           _GetOutGlobals 
0148 17B7
0149 17B7 F4 FF 00              pea   $00FF
0150 17BA F4 80 00              pea   $0080
0151 17BD A2 0C 0A 22           _SetOutGlobals 
0152 17C4
0153 17C4 F4 00 00              pea   $0000
0154 17C7 F4 00 00 F4           pushlong #00000003 
0155 17CD A2 0C 10 22           _SetOutputDevice 
0156 17D4
0157 17D4 F4 00 00              pea   0
0158 17D7 A2 0C 15 22           _InitTextDev 
0159 17DE F4 01 00              pea   1
0160 17E1 A2 0C 15 22           _InitTextDev 
0161 17E8
0162 17E8
0163 17E8
0164 17E8 C2 30        DoTrace  rep   #$30
0165 17EA F4 FC 00 F4           PushLong #Prompt               ;Print the prompt line
0166 17F0 A2 0C 1A 22           _WriteLine 
0167 17F7
0168 17F7 20 68 1A     GetKey   jsr   ReadKey
0169 17FA 29 7F 00              and   #$007F                   ;Force upper case & high byte clear
0170 17FD C9 61 00              cmp   #'a'
0171 1800 90 03                 bcc   Upper
0172 1802 49 20 00              eor   #$0020
0173 1805 C9 55 00     Upper    cmp   #'U'
0174 1808 F0 20                 beq   UList                    ;Used list
0175 180A C9 50 00              cmp   #'P'
0176 180D F0 20                 beq   PList                    ;Purged list
0177 180F C9 46 00              cmp   #'F'
0178 1812 F0 20                 beq   FList                    ;Free list
0179 1814 C9 51 00              cmp   #'Q'                     ;Quit
0180 1817 D0 DE                 bne   GetKey                   ;Invalid character.  Go get another
0181 1819
0182 1819 C2 30        Done     rep   #$30
0183 181B A2 0C 0A 22           _SetOutGlobals                 ;Restore the globals
0184 1822 A2 0C 10 22           _SetOutputDevice               ;Set the output device
0185 1829
0186 1829                       ENTRY PeekerRTL 
0187 1829              PeekerRTL                               ;       ;Shut down call does nothing
0188 1829 6B                    rtl                            ;Back to the DA manager
0189 182A
0190 182A
0191 182A
0192 182A
0193 182A
0194 182A A2 00 00     UList    ldx   #0                       ;Memlist
0195 182D 80 0A                 bra   doit
0196 182F A2 04 00     PList    ldx   #4                       ;EmptyList
0197 1832 80 05                 bra   doit
0198 1834 A2 08 00     FList    ldx   #8                       ;FreeList
0199 1837 80 00                 bra   doit
0200 1839
0201 1839
0202 1839
0203 1839              doit                                    ;
0204 1839 08                    php                            ;Save interrupt status
0205 183A BF 00 16 E1           lda   >MeMList,x               ;Get the list to do
0206 183E 85 92                 sta   Ptr
0207 1840 BF 02 16 E1           lda   >MemList+2,x
0208 1844 85 94                 sta   Ptr+2
0209 1846
0210 1846 64 90                 stz   mycount                  ;Handle count
0211 1848 64 AD                 stz   MyTotal                  ;Free space
0212 184A 64 AF                 stz   MyTotal+2
0213 184C
0214 184C F4 FC 00 F4           pushlong #TitleLine 
0215 1852 A2 0C 1A 22           _WriteLine 
0216 1859
0217 1859 E2 30                 sep   #$30
0218 185B                       longa off
0219 185B                       longi off
0220 185B
0221 185B              prloop    
0222 185B 20 C9 1A              jsr   Freeze
0223 185E B0 23                 bcs   NoTotal
0224 1860
0225 1860 A5 92                 lda   ptr                      ;Nil pointer?
0226 1862 05 93                 ora   ptr+1
0227 1864 05 94                 ora   ptr+2
0228 1866 D0 1F                 bne   NotDone                  ;Br if not nil
0229 1868 A5 AD                 lda   MyTotal                  ;If total = 0 don't print it
0230 186A 05 AE                 ora   MyTotal+1
0231 186C 05 B0                 ora   MyTotal+3
0232 186E F0 13                 beq   NoTotal
0233 1870
0234 1870 A2 3C                 ldx   #60                      ;Print the total free space
0235 1872 BF 00 19 FC  MoveTotal lda   >TotalLine,x
0236 1876 95 B1                 sta   Line,x
0237 1878 CA                    dex   
0238 1879 10 F7                 bpl   MoveTotal
0239 187B A2 1D                 ldx   #MyTotal-MyCount
0240 187D 20 F8 19              jsr   b3
0241 1880 20 38 1A              jsr   DoLine
0242 1883
0243 1883
0244 1883
0245 1883 28           NoTotal  plp                            ;Restore int status
0246 1884 4C E8 17              jmp   Dotrace                  ;Done with list. Go prompt for another
0247 1887
0248 1887 64 B1        NotDone  stz   line                     ;New line
0249 1889
0250 1889 A0 13                 ldy   #Hsize-1                 ;Move the info from the handle into ZP
0251 188B B7 92        mvloop   lda   [ptr],y
0252 188D BB                    tyx   
0253 188E 95 95                 sta   Buffer,x
0254 1890 88                    dey   
0255 1891 10 F8                 bpl   mvloop
0256 1893
0257 1893
0258 1893
0259 1893 20 3F 19              jsr   PrintThisLine
0260 1896
0261 1896 80 C3                 bra   prloop
0262 1898
0263 1898
0264 1898
0265 1898              ;-----------------------------------------------------------
0266 1898              ;
0267 1898              ; Header lines used above.
0268 1898              ;
0269 1898 32           Prompt   DC B:50
0270 1899 55 3D 20 55           DC B:'U= Used list  P= Purge list  F= Free list  Q= Quit'
0271 18CB
0272 18CB 34 8D 8D     TitleLine DC B:52,$8D,$8D
0273 18CE 23 20 20 20           DC B:'#    Handle  Addr  Attr  ID    Size    Prev   Next'
0274 1900
0275 1900 35 8D        TotalLine DC B:53,$8D
0276 1902 20 20 20 20           DC B:'                                  Total Free Memory ='
0277 1937 20 20 20 20           DC B:'        '
0278 193F
0279 193F
0280 193F
0281 193F                       ENDP 
0282 193F
0283 193F              ****************************************************************
0284 193F              *
0285 193F              PrintThisLine PROC 
0286 193F              *
0287 193F              * This is the routine that prints the contents of the
0288 193F              * handle in buffer.  It also prints the free space between
0289 193F              * this handle and the next (if there is any.
0290 193F              *
0291 193F              *
0292 193F              * Inputs:
0293 193F              *	Buffer contains the handle to print
0294 193F              *	MyCount contains the number of this handle
0295 193F              *
0296 193F              * Outputs:
0297 193F              *	PTR is updated to point to the next handle.
0298 193F              *
0299 193F              * External Refs:
0300 193F              *	none
0301 193F              *
0302 193F              * Entry Points:
0303 193F                       ENTRY B3 
0304 193F                       ENTRY DoLine 
0305 193F              *
0306 193F              * Called in 8 bit native mode!
0307 193F                       longa off                      ; mode
0308 193F                       longi off
0309 193F              *
0310 193F              ****************************************************************
0311 193F
0312 193F
0313 193F C2 20                 rep   #$20
0314 1941                       longa on
0315 1941
0316 1941 64 A9                 stz   MyDelta                  ;MyDelta = free space after block
0317 1943 64 AB                 stz   MyDelta+2
0318 1945
0319 1945 A5 A5                 lda   ptr2
0320 1947 05 A7                 ora   ptr2+2                   ;Nil?
0321 1949 F0 2F                 beq   NoDelta
0322 194B
0323 194B A0 02                 ldy   #2                       ;Addr of next can't be 0
0324 194D A7 A5                 lda   [ptr2]
0325 194F 17 A5                 ora   [ptr2],y
0326 1951 F0 27                 beq   NoDelta
0327 1953
0328 1953
0329 1953 A7 A5                 lda   [ptr2]                   ;Calc free space after block
0330 1955 38                    sec   
0331 1956 E7 92                 sbc   [ptr]
0332 1958 85 A9                 sta   MyDelta
0333 195A B7 A5                 lda   [ptr2],y
0334 195C F7 92                 sbc   [ptr],y
0335 195E 85 AB                 sta   MyDelta+2
0336 1960 A5 A9                 lda   MyDelta
0337 1962 38                    sec   
0338 1963 E5 9D                 sbc   Buffer+hndl_size
0339 1965 85 A9                 sta   MyDelta
0340 1967 A5 AB                 lda   MyDelta+2
0341 1969 E5 9F                 sbc   Buffer+hndl_size+2
0342 196B 85 AB                 sta   MyDelta+2
0343 196D
0344 196D A5 A9                 lda   MyDelta                  ;Add to total
0345 196F 18                    clc   
0346 1970 65 AD                 adc   MyTotal
0347 1972 85 AD                 sta   MyTotal
0348 1974 A5 AB                 lda   MyDelta+2
0349 1976 65 AF                 adc   MyTotal+2
0350 1978 85 AF                 sta   MyTotal+2
0351 197A
0352 197A E6 90        NoDelta  inc   MyCount                  ;Inc handle count
0353 197C
0354 197C E2 30                 sep   #$30
0355 197E                       longa off
0356 197E                       longi off
0357 197E
0358 197E              * Now print out the info from the handle
0359 197E
0360 197E A2 00                 ldx   #0                       ;Handle #
0361 1980 20 FF 19              jsr   b2
0362 1983
0363 1983 A2 02                 ldx   #2                       ;Handle address
0364 1985 20 F8 19              jsr   b3
0365 1988
0366 1988 A2 05                 ldx   #Hndl_Addr+5             ;Block address
0367 198A 20 F8 19              jsr   b3
0368 198D
0369 198D A2 09                 ldx   #Hndl_Attr+5             ;Attributes
0370 198F 20 FF 19              jsr   b2
0371 1992
0372 1992 A2 0B                 ldx   #Hndl_Owner+5            ;Owner
0373 1994 20 FF 19              jsr   b2
0374 1997
0375 1997 A2 0D                 ldx   #Hndl_Size+5             ;Size
0376 1999 20 F1 19              jsr   b4
0377 199C
0378 199C A2 11                 ldx   #Hndl_Prev+5             ;Pointer to previous
0379 199E 20 F8 19              jsr   B3
0380 19A1
0381 19A1 A2 15                 ldx   #Hndl_Next+5             ;Pointer to next
0382 19A3 20 F8 19              jsr   B3
0383 19A6
0384 19A6 20 38 1A              jsr   DoLine                   ;Print the line
0385 19A9
0386 19A9 A5 A9                 lda   MyDelta                  ;Any Delta?
0387 19AB 05 AA                 ora   MyDelta+1
0388 19AD 05 AB                 ora   MyDelta+2
0389 19AF F0 36                 beq   NoDelta2
0390 19B1
0391 19B1 C2 30                 rep   #$30                     ;for the free space, figure where it starts
0392 19B3                       longa on
0393 19B3                       longi on
0394 19B3 A5 95                 lda   Buffer+Hndl_Addr
0395 19B5 18                    clc   
0396 19B6 65 9D                 adc   Buffer+Hndl_Size
0397 19B8 85 95                 sta   Buffer+Hndl_Addr
0398 19BA A5 97                 lda   Buffer+Hndl_Addr+2
0399 19BC 65 9F                 adc   Buffer+Hndl_Size+2
0400 19BE 85 97                 sta   Buffer+Hndl_Addr+2
0401 19C0 A5 95                 lda   Buffer+Hndl_Addr
0402 19C2 D0 02                 bne   @NoCarry
0403 19C4 A5 97                 lda   Buffer+Hndl_Addr+2
0404 19C6              @NoCarry  
0405 19C6
0406 19C6
0407 19C6 A5 A9                 lda   MyDelta                  ;and how big it is
0408 19C8 85 9D                 sta   Buffer+Hndl_Size
0409 19CA A5 AB                 lda   MyDelta+2
0410 19CC 85 9F                 sta   Buffer+Hndl_Size+2
0411 19CE
0412 19CE E2 30                 sep   #$30
0413 19D0                       longa off
0414 19D0                       longi off
0415 19D0
0416 19D0 A0 0C                 ldy   #4+1+6+1
0417 19D2 20 29 1A              jsr   blanks
0418 19D5
0419 19D5 A2 05                 ldx   #Hndl_Addr+5             ;Block address
0420 19D7 20 F8 19              jsr   b3
0421 19DA
0422 19DA
0423 19DA A0 0A                 ldy   #1+4+4+1
0424 19DC 20 29 1A              jsr   blanks
0425 19DF
0426 19DF A2 0D                 ldx   #Hndl_Size+5             ;Size
0427 19E1 20 F1 19              jsr   b4
0428 19E4
0429 19E4 20 38 1A              jsr   DoLine                   ;Print the line
0430 19E7
0431 19E7              NoDelta2  
0432 19E7
0433 19E7
0434 19E7 A2 03                 ldx   #3                       ;Go to the next handle
0435 19E9 B5 A5        mvlp2    lda   Ptr2,x
0436 19EB 95 92                 sta   Ptr,x
0437 19ED CA                    dex   
0438 19EE 10 F9                 bpl   mvlp2
0439 19F0
0440 19F0 60                    rts   
0441 19F1
0442 19F1
0443 19F1
0444 19F1              ;-----------------------------------------------------------
0445 19F1              ;
0446 19F1              ; Code that prints the parts of the handle.  On entry,
0447 19F1              ; the x-reg holds the offset from MyCount of the item
0448 19F1              ; to print.
0449 19F1              ;
0450 19F1              ; After an item is printed, a blank is printed.
0451 19F1              ;
0452 19F1
0453 19F1 DA           b4       phx                            ;Print 4 byte number
0454 19F2 B5 93                 lda   mycount+3,x
0455 19F4 20 0F 1A              jsr   prbyte
0456 19F7 FA                    plx   
0457 19F8 DA           b3       phx                            ;Print 3 byte number
0458 19F9 B5 92                 lda   mycount+2,x
0459 19FB 20 0F 1A              jsr   prbyte
0460 19FE FA                    plx   
0461 19FF DA           b2       phx                            ;Print 2 byte number
0462 1A00 B5 91                 lda   mycount+1,x
0463 1A02 20 0F 1A              jsr   prbyte
0464 1A05 FA                    plx   
0465 1A06 B5 90        b1       lda   mycount,x                ;Print 1 byte number
0466 1A08 20 0F 1A              jsr   prbyte
0467 1A0B 20 34 1A              jsr   prblnk                   ;Print a blank
0468 1A0E
0469 1A0E 60                    rts   
0470 1A0F
0471 1A0F              ;-----------------------------------------------------------
0472 1A0F              ;
0473 1A0F              ; Puts a hex byte in the output buffer.
0474 1A0F              ;
0475 1A0F              prbyte    
0476 1A0F 48                    pha   
0477 1A10 4A                    lsr   A
0478 1A11 4A                    lsr   A
0479 1A12 4A                    lsr   A
0480 1A13 4A                    lsr   A
0481 1A14 20 1A 1A              jsr   prbyte2
0482 1A17 68                    pla   
0483 1A18 29 0F                 and   #$0F
0484 1A1A
0485 1A1A              prbyte2   
0486 1A1A 09 B0                 ora   #$B0
0487 1A1C C9 BA                 cmp   #$BA
0488 1A1E 90 02                 bcc   cout
0489 1A20 69 06                 adc   #6
0490 1A22
0491 1A22 A6 B1        cout     ldx   line                     ;Put char in output buffer
0492 1A24 95 B2                 sta   line+1,x
0493 1A26 E6 B1                 inc   line
0494 1A28 60                    rts   
0495 1A29
0496 1A29
0497 1A29              ;-----------------------------------------------------------
0498 1A29              ;
0499 1A29              ; Puts the number of blanks passed in the y-reg into
0500 1A29              ; the output buffer.
0501 1A29              ;
0502 1A29              Blanks    
0503 1A29 C0 00                 cpy   #0
0504 1A2B F0 06                 beq   @Done
0505 1A2D
0506 1A2D 20 34 1A     @again   jsr   prblnk
0507 1A30 88                    dey   
0508 1A31 D0 FA                 bne   @again
0509 1A33 60           @done    rts   
0510 1A34
0511 1A34
0512 1A34
0513 1A34              ;-----------------------------------------------------------
0514 1A34              ;
0515 1A34              ; Puts one blank in the output buffer.
0516 1A34              ;
0517 1A34              prblnk                                  ;Prints a blank
0518 1A34 A9 A0                 lda   #$A0
0519 1A36 80 EA                 bra   cout
0520 1A38
0521 1A38
0522 1A38              ;-----------------------------------------------------------
0523 1A38              ;
0524 1A38              ; Actually prints the line buffer and zeros the line 
0525 1A38              ; size count
0526 1A38 C2 30        DoLine   rep   #$30                     ;Print the line
0527 1A3A                       longa on
0528 1A3A                       longi on
0529 1A3A
0530 1A3A F4 00 00 F4           PushLong #Line 
0531 1A40 A2 0C 1A 22           _WriteLine 
0532 1A47 E2 30                 sep   #$30
0533 1A49                       longa off
0534 1A49                       longi off
0535 1A49 64 B1                 stz   Line                     ;Line index set to 0 for new line
0536 1A4B 60                    rts   
0537 1A4C
0538 1A4C                       ENDP 
0539 1A4C
0540 1A4C
0541 1A4C
0542 1A4C              ****************************************************************
0543 1A4C              *
0544 1A4C              PeekerID PROC 
0545 1A4C              *
0546 1A4C              * This is the data that defines a classic desk accessory.
0547 1A4C              *
0548 1A4C              *
0549 1A4C              * Inputs:
0550 1A4C              *	none
0551 1A4C              *
0552 1A4C              * Outputs:
0553 1A4C              *	none
0554 1A4C              *
0555 1A4C              * External Refs:
0556 1A4C              *	none
0557 1A4C              *
0558 1A4C              * Entry Points:
0559 1A4C              *	none
0560 1A4C              *
0561 1A4C                       longa on                       ; mode
0562 1A4C                       longi on
0563 1A4C              *
0564 1A4C              ****************************************************************
0565 1A4C
0566 1A4C
0567 1A4C 52 1A FC 00           DC L:PeekerName                ; pointer to real id section.
0568 1A50 00 00                 DC W:0                         ; just in case someone wants to lock us
0569 1A52
0570 1A52 0D 4D 65 6D  PeekerName DC C:'Memory Peeker'         ; da name
0571 1A60 9A 17 FC 00           DC L:Peeker                    ; pointer to peeker routine
0572 1A64 29 18 FC 00           DC L:PeekerRTL                 ; pointer to ShutDown call
0573 1A68
0574 1A68
0575 1A68                       ENDP 
0576 1A68
0577 1A68
0578 1A68
0579 1A68              ****************************************************************
0580 1A68              *
0581 1A68              ReadKey  PROC 
0582 1A68              *
0583 1A68              * Reads key from keyboard using the event manager or
0584 1A68              * the hardware (as necessary).
0585 1A68              *
0586 1A68              *
0587 1A68              * Inputs:
0588 1A68              *	none
0589 1A68              *
0590 1A68              * Outputs:
0591 1A68              *	a-reg   the key read
0592 1A68              *
0593 1A68              * External Refs:
0594 1A68              *	none
0595 1A68              *
0596 1A68              * Entry Points:
0597 1A68              *	none
0598 1A68              *
0599 1A68                       longa on                       ; mode
0600 1A68                       longi on
0601 1A68              *
0602 1A68              ****************************************************************
0603 1A68
0604 1A68              ;
0605 1A68              ; First try using the event manager
0606 1A68              ;
0607 1A68              Again     
0608 1A68 48                    pha                            ; space for result
0609 1A69 F4 FF FF              PushWord #$FFFF                ; all events
0610 1A6C F4 00 00 F4           PushLong #EventRecord 
0611 1A72 A2 06 0A 22           _GetNextEvent 
0612 1A79 B0 12                 bcs   ReadItMyself
0613 1A7B
0614 1A7B 68                    pla   
0615 1A7C F0 EA                 beq   Again
0616 1A7E
0617 1A7E A5 80                 lda   EventType
0618 1A80 C9 03 00              cmp   #3                       ; key down
0619 1A83 F0 05                 beq   GotAKey
0620 1A85 C9 05 00              cmp   #5                       ; auto key down
0621 1A88 D0 DE                 bne   Again
0622 1A8A
0623 1A8A A5 82        GotAKey  lda   EventKey
0624 1A8C
0625 1A8C 60                    rts   
0626 1A8D
0627 1A8D
0628 1A8D
0629 1A8D              ReadItMyself                            ; 
0630 1A8D 68                    pla   
0631 1A8E
0632 1A8E E2 30                 sep   #%00110000
0633 1A90 AF 00 C0 E0  Loop     lda   >$E0C000
0634 1A94 10 FA                 bpl   Loop
0635 1A96 8F 10 C0 E0           sta   >$E0C010
0636 1A9A C2 30                 rep   #%00110000
0637 1A9C
0638 1A9C 29 7F 00              and   #$007F
0639 1A9F
0640 1A9F 60                    rts   
0641 1AA0                       ENDP 
0642 1AA0
0643 1AA0
0644 1AA0              KeyDown  PROC 
0645 1AA0
0646 1AA0              ; if the event manager is active i need to get keys from
0647 1AA0              ; it.
0648 1AA0 F4 00 00              PushWord #0                    ; space for result
0649 1AA3 F4 28 00              PushWord #%0000000000101000 
0650 1AA6 F4 00 00 F4           PushLong #EventRecord 
0651 1AAC A2 06 0B 22           _EventAvail 
0652 1AB3 B0 05                 bcs   ReadItMyself
0653 1AB5
0654 1AB5 68                    pla   
0655 1AB6 F0 0F                 beq   NoKeyDown
0656 1AB8 80 0B                 bra   YesKeyDown
0657 1ABA
0658 1ABA
0659 1ABA
0660 1ABA              ReadItMyself                            ; 
0661 1ABA 68                    pla   
0662 1ABB E2 30                 sep   #%00110000
0663 1ABD AF 00 C0 E0  Loop     lda   >$E0C000
0664 1AC1 C2 30                 rep   #%00110000
0665 1AC3
0666 1AC3 10 02                 bpl   NoKeyDown
0667 1AC5
0668 1AC5 38           YesKeyDown sec   
0669 1AC6 60                    rts   
0670 1AC7
0671 1AC7 18           NoKeyDown clc   
0672 1AC8 60                    rts   
0673 1AC9                       ENDP 
0674 1AC9
0675 1AC9
0676 1AC9
0677 1AC9              ****************************************************************
0678 1AC9              *
0679 1AC9              Freeze   PROC 
0680 1AC9              *
0681 1AC9              * This routine looks at the keyboard.  If there is a key pending
0682 1AC9              * it reads it.  If the key is ESCAPE, we report done
0683 1AC9              * If it is not escape, we wait for another key.  If that one
0684 1AC9              * is ESCAPE, we report done.  Otherwise we report not done.
0685 1AC9              *
0686 1AC9              *
0687 1AC9              * Inputs:
0688 1AC9              *	none
0689 1AC9              *
0690 1AC9              * Outputs:
0691 1AC9              *	carry clear = not done
0692 1AC9              *	carry set   = done
0693 1AC9              *
0694 1AC9              * External Refs:
0695 1AC9                       import ReadKey 
0696 1AC9                       import KeyDown 
0697 1AC9              *
0698 1AC9              * Entry Points:
0699 1AC9              *	none
0700 1AC9              *
0701 1AC9              *
0702 1AC9              * Wow!   This is called in 8bit native mode. and it returns that
0703 1AC9              * way.
0704 1AC9              *
0705 1AC9                       longa off                      ; mode
0706 1AC9                       longi off
0707 1AC9              *
0708 1AC9              ****************************************************************
0709 1AC9 08                    php                            ; save mode
0710 1ACA C2 30                 rep   #$30
0711 1ACC                       longa on
0712 1ACC                       longi on
0713 1ACC
0714 1ACC 20 A0 1A              jsr   KeyDown
0715 1ACF 90 13                 bcc   Done
0716 1AD1
0717 1AD1 20 68 1A              jsr   ReadKey                  ; clear this key
0718 1AD4 C9 1B 00              cmp   #27                      ; if esc then signal quit
0719 1AD7 F0 08                 beq   Quit
0720 1AD9
0721 1AD9 20 68 1A              jsr   ReadKey                  ; Wait for next key
0722 1ADC C9 1B 00              cmp   #27                      ; if esc then signal quit
0723 1ADF D0 03                 bne   Done 
0724 1AE1
0725 1AE1
0726 1AE1 28           Quit     plp   
0727 1AE2 38                    sec   
0728 1AE3 60                    rts   
0729 1AE4
0730 1AE4 28           Done     plp   
0731 1AE5 18                    clc   
0732 1AE6 60                    rts   
0733 1AE7
0734 1AE7                       ENDP 
0735 1AE7
0736 1AE7
0737 1AE7
0738 1AE7
0739 1AE7
0740 1AE7                       END   
